/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.projector;

import dev.compactmods.crafting.api.field.IActiveWorldFields;
import dev.compactmods.crafting.api.field.IMiniaturizationField;
import dev.compactmods.crafting.core.CCBlocks;
import dev.compactmods.crafting.core.CCCapabilities;
import dev.compactmods.crafting.projector.FieldProjectorBlock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class FieldProjectorEntity
extends BlockEntity {
    protected LazyOptional<IMiniaturizationField> fieldCap = LazyOptional.empty();
    protected LazyOptional<IActiveWorldFields> levelFields = LazyOptional.empty();

    public FieldProjectorEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CCBlocks.FIELD_PROJECTOR_TILE.get(), pos, state);
    }

    public Direction getProjectorSide() {
        return ((Direction)this.m_58900_().m_61143_((Property)FieldProjectorBlock.FACING)).m_122424_();
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        this.levelFields = this.f_58857_.getCapability(CCCapabilities.FIELDS);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null) {
            if (this.f_58857_.f_46443_) {
                this.loadFieldFromState();
            } else {
                MinecraftServer server = this.f_58857_.m_142572_();
                if (server != null) {
                    server.m_6937_((Runnable)new TickTask(0, this::loadFieldFromState));
                }
            }
        }
    }

    private void loadFieldFromState() {
        this.fieldCap = (LazyOptional)this.levelFields.lazyMap(fields -> {
            BlockState state = this.m_58900_();
            return fields.getLazy(FieldProjectorBlock.getFieldCenter(state, this.f_58858_));
        }).orElse((Object)LazyOptional.empty());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CCCapabilities.FIELDS) {
            return this.levelFields.cast();
        }
        if (cap == CCCapabilities.MINIATURIZATION_FIELD) {
            return this.fieldCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public AABB getRenderBoundingBox() {
        return this.fieldCap.map(f -> f.getBounds().m_82400_(20.0)).orElse(new AABB(this.f_58858_).m_82400_(20.0));
    }

    public LazyOptional<IMiniaturizationField> getField() {
        return this.fieldCap.cast();
    }

    public void setFieldRef(LazyOptional<IMiniaturizationField> fieldRef) {
        this.fieldCap = fieldRef;
        this.m_6596_();
    }
}

